//
//  MCCollapsibleSheetWidget.h
//  CollapsibleWidget
//
//  Created by Michael Clark on 11/07/2005.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>



typedef struct __MCCSWFlags {
#ifdef __BIG_ENDIAN__
    unsigned int	displayCloseButton:1;
	unsigned int    displayDisclosureButton:1;
	unsigned int    drawBodyBackground:1;
	unsigned int    animateCollapse:1;
	unsigned int    animateAddRemoval:1;
#else
	unsigned int    animateAddRemoval:1;
	unsigned int    animateCollapse:1;
	unsigned int    drawBodyBackground:1;
	unsigned int    displayDisclosureButton:1;
    unsigned int	displayCloseButton:1;
#endif
} _MCCSWFlags;


@class MCCSWHeaderView, MCCSWBodyView, MCCSWCanvasView;

@interface MCCollapsibleSheetWidget : NSView {

	MCCSWHeaderView*         __headerView;  // not retained
	MCCSWBodyView*           __bodyView; // retained - because we remove it from view hierarchy and add back
	NSRect                   __bodyOutterRect;
	
	BOOL                     __isCollapsed;
	NSImage*                 __cachedCollapsedImage;
	float                    __collapseAnimationDistance;
	float                    __collapseAnimationEndPoint;
	float                    __collapseAnimationCurrentPoint;
	BOOL                     __isCollapseAnimationInProgress;
	NSCalendarDate*          __animationStartedTimestamp;
	int                      __animationType; // 0 - collapse  1 - expand  2 - delete
	
	NSColor*                 __widgetColor;
	
	_MCCSWFlags              __flags;
	
	id                       __dragDelegate;

	NSNumber *cswSheetTopMargin;
	NSNumber *cswSheetBottomMargin;
	NSNumber *cswSheetHeightDelta;
	
	NSColor *bodyBgColor;
}

// Either or both of headerViewClassName and bodyViewClassName can be nil, in which case the defaults will be used and calling this will have the same 
//  effect as calling initWithFrame: widgetColor:
- (id)initWithFrame: (NSRect)frame widgetColor: (NSColor*)color headerViewClassName: (NSString*)headerClassName bodyViewClassName: (NSString*)bodyClassName;
- (id)initWithFrame: (NSRect)frame widgetColor: (NSColor*)color;
- (id)initWithFrame: (NSRect)frame;


- (IBAction)toggleCollapseState: (id)sender;
- (IBAction)removeWidgetFromCanvas: (id)sender;

- (void)prepareToCollapse;
- (float)prepareToExpand;
- (void)finishCollapse;
- (void)finishExpand;
- (float)performCollapseAnimationTick;

- (float)preferredHeight;

// Wrapper for superview for coding clarity
- (MCCSWCanvasView*)canvasView;





// Accessors for the header and body views - these cannot be set, that must be done at initialization time with the appropriate initializer
- (MCCSWHeaderView *)headerView;
- (MCCSWBodyView *)bodyView;

- (NSImage *)widgetImageRepresentation;

- (BOOL)isCollapsed;

- (NSColor *)widgetColor;
- (void)setWidgetColor:(NSColor *)aWidgetColor;

- (id)dragDelegate;
- (void)setDragDelegate:(id)aDragDelegate;

- (NSColor *)bodyBgColor;
- (void)setBodyBgColor:(NSColor *)aBodyBgColor;

// Margins (defaults taken from defines, but overrideable if necessary)
- (NSNumber *)cswSheetTopMargin;
- (void)setCswSheetTopMargin:(NSNumber *)aCswSheetTopMargin;
- (NSNumber *)cswSheetBottomMargin;
- (void)setCswSheetBottomMargin:(NSNumber *)aCswSheetBottomMargin;
- (NSNumber *)cswSheetHeightDelta;
- (void)setCswSheetHeightDelta:(NSNumber *)aCswSheetHeightDelta;
@end
